library ieee;
use ieee.std_logic_1164.all;

-- The clock enable generator produces an active enable
-- every second clock cycle

entity clockengen is 
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    en_o:           out std_ulogic
  );
end; 

architecture struct of clockengen is

  component dflipflop is 
    port (
      res_n:          in std_ulogic; -- Reset is active low
      clk_i:          in std_ulogic;
      d_i:            in std_ulogic;
      q_o:            out std_ulogic
    );
  end component;
 
  signal d, q : std_ulogic;

begin

  ff_i0 : dflipflop
  port map (
    res_n => res_n,
    clk_i => clk_i,
    d_i   => d,  
    q_o   => q); 
  
  d <= not(q);    
  en_o <= q;

end; -- architecture


