library ieee;
use ieee.std_logic_1164.all;

-- Rising Edge triggered D Flipflop with asynchronous reset
-- Reset is active low

entity dflipflop is 
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    d_i:            in std_ulogic;
    q_o:            out std_ulogic
  );
end; 

architecture rtl of dflipflop is
  signal q : std_ulogic;
begin
  
  ff_p: process(clk_i, res_n)
  begin
    if res_n = '0' then
      q <= '0';
    elsif rising_edge(clk_i) then
      q <= d_i; 
    end if;
  end process;

  q_o <= q;

end; -- architecture


