library ieee;
use ieee.std_logic_1164.all;

entity vgatop is 
  port (
    clk_i : in std_ulogic;
    res_n : in std_ulogic;
    vga_r_o:      out std_ulogic_vector(3 downto 0);
    vga_g_o:      out std_ulogic_vector(3 downto 0);
    vga_b_o:      out std_ulogic_vector(3 downto 0);
    vga_hs_o:     out std_ulogic;
    vga_vs_o:     out std_ulogic
  );
end; 

architecture struct of vgatop is

  component clockengen is 
    port (
      res_n:          in std_ulogic; -- Reset is active low
      clk_i:          in std_ulogic;
      en_o:           out std_ulogic
    );
  end component; 

  component syncgen is 
    generic (
      active_cnt_g : std_ulogic_vector(9 downto 0);
      fp_cnt_g     : std_ulogic_vector(9 downto 0); 
      sync_cnt_g   : std_ulogic_vector(9 downto 0); 
      bp_cnt_g     : std_ulogic_vector(9 downto 0)
    ); 
    port (
      clk_i :         in std_ulogic;
      res_n :         in std_ulogic;
      en_i  :         in std_ulogic;
      sync_o :       out std_ulogic;
      done_o:         out std_ulogic;
      cnt_o:          out std_ulogic_vector(9 downto 0);  
      active_o:       out std_ulogic  
    );
  end component;


begin

 
      			   
end; -- architecture


