library ieee;
use ieee.std_logic_1164.all;

-- HSYNC pixel counter and compare module

entity synccnt is 
  generic (
    active_cnt_g : std_ulogic_vector(11 downto 0);
    fp_cnt_g     : std_ulogic_vector(11 downto 0); 
    sync_cnt_g   : std_ulogic_vector(11 downto 0); 
    bp_cnt_g     : std_ulogic_vector(11 downto 0)
  );  
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;
    en_i  :           in std_ulogic;
    sel_cmp_i:        in std_ulogic_vector(1 downto 0); 
    cnt_o :          out std_ulogic_vector(11 downto 0); 
    done_o :         out std_ulogic
  );
end; 

architecture rtl of synccnt is

  component counter is
    port (
      clk_i       : in  std_ulogic;
      res_n       : in  std_ulogic;     -- Asynchronous Reset
      en_i        : in  std_ulogic;
      sync_res_ni : in  std_ulogic;     -- Active low synchronous reset
      cnt_o       : out std_ulogic_vector(11 downto 0)
      );
  end component;

  signal cnt, cmp : std_ulogic_vector(11 downto 0);

  signal sync_res_n, done : std_ulogic;

begin

  counter_i0 : counter
    port map (
      clk_i       => clk_i,
      res_n       => res_n,
      en_i        => en_i,
      sync_res_ni => sync_res_n,
      cnt_o       => cnt
      );

  done       <= '0';
  sync_res_n <= '1';

  -- Output 
  cnt_o  <= cnt;
  done_o <= done; 
    
end; -- architecture


