library ieee;
use ieee.std_logic_1164.all;

entity rising_edge_detector is
  port (
    clk_i  : in  std_ulogic;
    rst_ni : in  std_ulogic;
    x_i    : in  std_ulogic;
    rise_o : out std_ulogic
    );
end rising_edge_detector;

architecture rtl of rising_edge_detector is

  signal q0, q1 : std_ulogic;           -- d-type flip-flop outputs
  
begin

  -- Flipflops
  ff0 : q0 <= '0' when rst_ni = '0' else x_i when rising_edge(clk_i);
  ff1 : q1 <= '0' when rst_ni = '0' else q0  when rising_edge(clk_i);

  output_logic : rise_o <= q0 and not q1;

end architecture rtl;

