library ieee;
use ieee.std_logic_1164.all;

entity t_clockengen is 
end; 

architecture tbench of t_clockengen is

  component clockengen is 
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    en_o:           out std_ulogic
  );
  end component; 

  signal res_n, clk, en : std_ulogic; 
  signal clken_p  : boolean := true;

begin

  dut : clockengen
    port map (
      clk_i => clk,
      res_n => res_n,
      en_o  => en);
    
  -- 50 mhz 
  -- clock generation 
  clock_p : process
  begin
    while clken_p loop
      clk <= '0'; wait for 10 ns;
      clk <= '1'; wait for 10 ns;
    end loop;
    wait;
  end process;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' after 10 ns;

  stimuli_p : process
  begin
    wait until res_n = '1';            -- wait until asynchronous reset ...
                                        -- ... is deactivated
    wait for 500 ns; 
    clken_p <= false;                   -- switch clock generator off
    wait;                               -- suspend proces
  end process;
      
			   
end; -- architecture


