library ieee;
use ieee.std_logic_1164.all;

entity t_syncgen is 
end; 

architecture tbench of t_syncgen is

  component clockengen is 
    port (
      res_n:          in std_ulogic; -- Reset is active low
      clk_i:          in std_ulogic;
      en_o:           out std_ulogic
    );
  end component; 

  component syncgen is 
    generic (
      active_cnt_g : std_ulogic_vector(11 downto 0);
      fp_cnt_g     : std_ulogic_vector(11 downto 0); 
      sync_cnt_g   : std_ulogic_vector(11 downto 0); 
      bp_cnt_g     : std_ulogic_vector(11 downto 0)
    ); 
    port (
      clk_i :         in std_ulogic;
      res_n :         in std_ulogic;
      en_i  :         in std_ulogic;
      sync_o :       out std_ulogic;
      done_o:         out std_ulogic;
      cnt_o:          out std_ulogic_vector(11 downto 0);  
      active_o:       out std_ulogic  
    );
  end component;

  signal clk, res_n, en, done, sync, active: std_ulogic;  
  signal pixcnt : std_ulogic_vector(11 downto 0);

  signal clken_p  : boolean := true;

begin

  -- 50 MHz 
  -- clock generation 
  clock_p : process
  begin
    while clken_p loop
      clk <= '0'; wait for 10 ns;
      clk <= '1'; wait for 10 ns;
    end loop;
    wait;
  end process;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' AFTER 10 ns;

  clken_p <= true, false after 3 us;

  clockengen_i0 : clockengen
    port map (
      res_n    => res_n,
      clk_i    => clk, 
      en_o     => en);

  hsyncgen_i0 : syncgen
    generic map (
      active_cnt_g => "000000010000", 
      fp_cnt_g     => "000000000111", 
      sync_cnt_g   => "000000001001", 
      bp_cnt_g     => "000000000011"  
    ) 
    port map (
      clk_i    => clk,
      res_n    => res_n, 
      en_i     => en,
      sync_o   => sync,
      done_o   => done,
      cnt_o    => pixcnt,  
      active_o => active); 

end; -- architecture


